// --------------------------------------------------------------------------
// COPYRIGHT (c) Freescale 2009
// Freescale Confidential Proprietary
//  All Rights Reserved
// --------------------------------------------------------------------------
//!\file    flexcan.c
//!\brief   
//
// TYPE: C Source file
// DEPARTMENT: MSG-IDC
// CREATED BY: Pankaj Kushwaha (B22414)
// --------------------------------------------------------------------------
// PURPOSE:  
// --------------------------------------------------------------------------
//
// --------------------------------------------------------------------------

#include "can.h"
#include "faraday.h"
//#define SYSCLK 128

#define LOM_DISABLED 0
#define LOM_ENABLED 1

typedef volatile struct FLEXCAN_tag *FLEXCAN_PTR;
FLEXCAN_PTR can;
typedef struct {
	UINT8 presdiv;
	UINT8 rjw;
	UINT8 pseg1;
	UINT8 pseg2;
	UINT8 propseg;
}BAUD_SETTINGS;
BAUD_SETTINGS bauds;
BAUD_SETTINGS baud_settings;

//function prototypes
void set_can_baud();
void set_bauds(UINT32 baud);

//USE CAN0 for EVB, CAN1 for CLUSTER
#define CAN0 0
#define CAN1 1
#define CAN CAN1
#if(CAN==CAN0)
  #define CAN_REGS FLEXCAN0
#elif(CAN==CAN1)
  #define CAN_REGS FLEXCAN1
#endif

void init_flexcan(){
	int i;
	can=&CAN_REGS;
        
        //clock
        

	/* CAN PIN MUXING */ 
#if(CAN==CAN0)
        reg32setbit(CCM_CSCDR2,CCM_CSCDR2_CAN0_EN_SHIFT);
        reg32_write_mask(IOMUXC_SW_MUX_CTL_PAD_PAD_36,1<<IOMUXC_SW_MUX_CTL_PAD_PAD_n_MUX_MODE_SHIFT,IOMUXC_SW_MUX_CTL_PAD_PAD_n_MUX_MODE_MASK);
        reg32_write_mask(IOMUXC_SW_MUX_CTL_PAD_PAD_37,1<<IOMUXC_SW_MUX_CTL_PAD_PAD_n_MUX_MODE_SHIFT,IOMUXC_SW_MUX_CTL_PAD_PAD_n_MUX_MODE_MASK);
        reg32setbit(IOMUXC_SW_MUX_CTL_PAD_PAD_36,IOMUXC_SW_MUX_CTL_PAD_PAD_n_IBE_SHIFT);
#elif(CAN==CAN1)
        reg32setbit(CCM_CSCDR2,CCM_CSCDR2_CAN1_EN_SHIFT);
        reg32_write_mask(IOMUXC_SW_MUX_CTL_PAD_PAD_38,1<<IOMUXC_SW_MUX_CTL_PAD_PAD_n_MUX_MODE_SHIFT,IOMUXC_SW_MUX_CTL_PAD_PAD_n_MUX_MODE_MASK);
        reg32_write_mask(IOMUXC_SW_MUX_CTL_PAD_PAD_39,1<<IOMUXC_SW_MUX_CTL_PAD_PAD_n_MUX_MODE_SHIFT,IOMUXC_SW_MUX_CTL_PAD_PAD_n_MUX_MODE_MASK);
        reg32setbit(IOMUXC_SW_MUX_CTL_PAD_PAD_38,IOMUXC_SW_MUX_CTL_PAD_PAD_n_IBE_SHIFT);
#endif
        
        //config
        can->MCR.R=0x00;
	can->MCR.B.MDIS = 0; /*bit 0 - Reading right to left (MSB to LSB)*/
	/*Configure CAN MCR registers*/
	can->MCR.B.SOFTRST = 1; /*bit 6*/
	while(can->MCR.B.SOFTRST == 1);
	/*Bit which can be accessed only in freeze mode*/
	can->MCR.B.HALT = 1; /*bit 3*/
	can->MCR.B.FRZ = 1;  /*bit 1*/
	while(can->MCR.B.FRZACK!=1);
        
        //can->MCR.B.BCC=0;  //KG
	can->MCR.B.MAXMB = 0x3F; /*bit 26 -31*/
	/*Disable FIFO*/
	can->MCR.B.RFEN=0;
	/*Self Reception disabled*/
	can->MCR.B.SRXDIS = 1;
	set_can_baud();
	/* Configure Remaining Bits of CR*/
        can->CTRL1.B.BOFFMSK = 0;
	can->CTRL1.B.ERRMSK = 0;
	can->CTRL1.B.LPB = 0;
	can->CTRL1.B.SMP = 1;
	can->CTRL1.B.BOFFREC = 0;
	can->CTRL1.B.TSYN = 0;
	can->CTRL1.B.LOM = 0;
	can->CTRL1.B.LBUF = 0;
	can->CTRL1.B.CLKSRC = 1;

	/* Initialize/Clear all memory buffers*/
	for (i=0;i<64;i++){
		/* Put MB's in inactive state*/
		can->BUF[i].CS.R = 0x00000000;
		can->BUF[i].ID.R = 0x00000000;
		/* Clear Data fields*/
		can->BUF[i].DATA.W[0] = 0x00000000;
		can->BUF[i].DATA.W[1] = 0x00000000;
	}

	/*Initialize MASK registers to check every bit*/
	can->RXMGMASK.R = 0x1FFFFFFF;
	can->RX14MASK.R = 0x1FFFFFFF;
	can->RX15MASK.R = 0x1FFFFFFF;
	/*Clear IFLAG registers*/
	can->IFLAG1.R = 0xFFFFFFFF;
	can->IFLAG2.R = 0xFFFFFFFF;
	/*Configure IMASK Registers to enable interrupt requests*/
	can->IMASK1.R = 0xFFFFFFFF;
	can->IMASK2.R = 0xFFFFFFFF;
	/*Clear Halt Bit*/
	can->MCR.B.FRZ = 0;
}


void set_can_baud(){
	set_bauds(50000);
	can->CTRL1.B.PRESDIV = bauds.presdiv;
	can->CTRL1.B.RJW = bauds.rjw;
	can->CTRL1.B.PSEG1 = bauds.pseg1;
	can->CTRL1.B.PSEG2 = bauds.pseg2;
	can->CTRL1.B.PROPSEG = bauds.propseg;
}


void set_bauds(UINT32 baud) {
	int SYSCLK=24;
	if ((SYSCLK == 128) || (SYSCLK == 80) || (SYSCLK == 144) || (SYSCLK == 160)) {
		bauds.presdiv = ((SYSCLK /16) * (1000000 /baud)) - 1;
		bauds.rjw = 3;
		bauds.pseg1 = 4;
		bauds.pseg2 = 4;
		bauds.propseg = 4;
	} else if ((SYSCLK == 152)) {
		bauds.presdiv = ((SYSCLK /19) * (1000000 /baud)) - 1;
		bauds.rjw = 3;
		bauds.pseg1 = 4;
		bauds.pseg2 = 4;
		bauds.propseg = 7;
	} else if (SYSCLK == 12) {
		bauds.presdiv = ((SYSCLK /12) * (1000000 /baud)) - 1;
		bauds.rjw = 2;
		bauds.pseg1 = 2;
		bauds.pseg2 = 2;
		bauds.propseg = 4;
	} else if (SYSCLK == 48) {
		bauds.presdiv = ((SYSCLK /12) * (1000000 /baud)) - 1;
		bauds.rjw = 2;
		bauds.pseg1 = 2;
		bauds.pseg2 = 2;
		bauds.propseg = 4;
	} else if (SYSCLK == 64) {
		baud_settings.presdiv = ((SYSCLK /16) * (1000000 /baud)) - 1;
		baud_settings.rjw = 2;
		baud_settings.pseg1 = 4;
		baud_settings.pseg2 = 4;
		baud_settings.propseg = 4;
	} else if ((SYSCLK == 8) || (SYSCLK == 16) || (SYSCLK == 24) || (SYSCLK	== 32)) {
		bauds.presdiv = ((SYSCLK /8) * (1000000 /baud)) - 1;
		bauds.rjw = 1;
		bauds.pseg1 = 1;
		bauds.pseg2 = 1;
		bauds.propseg = 2;
	}else if((SYSCLK==40)){
		bauds.presdiv = ((SYSCLK /20) * (1000000 /baud)) - 1;
		bauds.rjw = 3;
		bauds.pseg1 = 6;
		bauds.pseg2 = 5;
		bauds.propseg = 5;
	}else if((SYSCLK==100)){
		bauds.presdiv = ((SYSCLK /10) * (1000000 /baud)) - 1;
		bauds.rjw = 3;
		bauds.pseg1 = 1;
		bauds.pseg2 = 2;
		bauds.propseg = 4;
	}
}



void transmit_can(UINT32 msg_id, UINT8 * ptr, UINT8 numofbytes){
	
        int timer;
	int i;
	int msg_length;
        int buf;
        
	can->CTRL1.B.LOM = LOM_DISABLED;
        msg_length = numofbytes;
        buf = 0;
	/* Clear Data fields*/
	can->BUF[buf].DATA.W[0] = 0x00000000;
	can->BUF[buf].DATA.W[1] = 0x00000000;
	/* Hold the transmit_can buffer inactive*/
	can->BUF[buf].CS.B.CODE = 0x8;
	/*		can->BUF[buf].CS.B.SRR = 0;*/
	/*Set RTR 0 -> if Data Frame*/
	/*Set RTR 1 -> if Remote Frame*/
	can->BUF[buf].CS.B.SRR =1;
	can->BUF[buf].CS.B.RTR =0;
	can->BUF[buf].CS.B.IDE=0;/*STD frame format*/
	can->BUF[buf].ID.B.STD_ID = msg_id;
	//Write the data if the frame is a data frame
	for (i=0;i<msg_length; i++){
		can->BUF[buf].DATA.B[i] = ptr[i];
	}
	can->BUF[buf].CS.B.LENGTH = msg_length;
	can->BUF[buf].CS.B.CODE = 0xC;
	timer = can->TIMER.R;  /*Unlock Message buffers*/
}

void receive_can(UINT32 msg_id, UINT8 * ptr, UINT8 numofbytes){
	int buf=1;
	can->CTRL1.B.LOM = LOM_DISABLED;
	/* Write MB Code Field = 0x0 to config as RX inactive */
	can->BUF[buf].CS.B.CODE = 0;
	/*STD frame format */
//	can->BUF[buf].CS.B.IDE=0;
        FLEXCAN0.BUF[buf].CS.B.IDE=0;
	/* Write standard MB IDs */
	can->BUF[buf].ID.B.STD_ID =msg_id;
	can->BUF[buf].CS.B.CODE = 0x4;
}

uint8_t c_message[8];
void sendHUD(uint16_t speed,uint16_t rpm, uint8_t mirror, uint8_t signal)
{
  c_message[0] = (uint8_t)rpm;//first byte of rpm
  c_message[1] = (uint8_t)(rpm>>8);//second byte of rpm
  c_message[2] = (uint8_t)speed;//first byte of speed
  c_message[3] = (uint8_t)(speed>>8);//second byte of speed
  c_message[4] = 0;//unused
  c_message[5] = 0;//unused
  c_message[6] = mirror;//mirror
  c_message[7] = signal;//sign  
  transmit_can(555,&c_message[0],8);
}
